#include <coleco.h>
#include <getput1.h>

/* From charset.c */
extern const byte PATTERNRLE[];
extern const byte COLORRLE[];
extern const byte SPATTERNRLE[];

/* From sticks_sprites.c */
extern const byte* const walkingsprites[];
extern const byte spriteAttr0[];

/* Game parameters */
const byte NBR_STICKS = 50;
const byte LIMIT_LEFT = 2;
const byte LIMIT_RIGHT = 29;
const byte LIMIT_TOP = 4;
const byte LIMIT_BOTTOM= 22;

struct player_attribs
{
    byte y;
    byte x;
    byte dir;
//    byte frame;
    unsigned int score;
} player;

volatile byte music_part;
volatile byte music_counter;
volatile byte nmi_count;

void update_music(void)
{
    music_counter++;
    if (music_counter>159) {
        music_counter = 0;
        music_part++;
        if (music_part>6) {
            music_part = 0;
        }
        switch (music_part)
        {
            case 0:
            case 1:
                play_sound(1);
                play_sound(2);
                play_sound(3);
                break;
            case 2:
            case 3:
                play_sound(4);
                play_sound(5);
                play_sound(6);
                break;
            case 4:
                play_sound(7);
                play_sound(8);
                play_sound(9);
                break;
            case 5:
                //play_sound(7);
                //play_sound(8);
                play_sound(10);
                break;
            case 6:
                play_sound(11);
                play_sound(12);
                play_sound(13);
                break;
        }
    }
}

byte check_stick(byte x,byte y)
{
    return (get_char(x,y) & 12);
}

void add_stick(byte nbr)
{
    byte i;
    byte y;
    byte x;
    byte c;

    for (i=0;i<nbr;i++)
    {
again_x:   
        x = rnd_byte(LIMIT_LEFT,LIMIT_RIGHT) & 30;    
        if (absdiff(player.x,x)<2) goto again_x;

again_y:   
        y = rnd_byte(LIMIT_TOP,LIMIT_BOTTOM);
        if (absdiff(player.y,y)==0) goto again_y;

        if (check_stick(x,y)) goto again_x;

        c = (rnd_byte(1,3) << 2) | ((y & 1) << 1);

        put_char(x,y,c);
        put_char(x+1,y,c+1);
    }
}

void erase_stick(byte x, byte y)
{
    byte c;
    c = (y & 1) << 1;
    x = x & 30;
    put_char(x,y,c);
    put_char(x+1,y,c+1);
}

void print_rank()
{
    register hl = player.score;

    char         *str = "Insane Pickin' Sticks VIII";//"Nubsaws"; //ranks[0];
    
    if (hl>=10)   str = "Kitty                     "; //ranks[1];
    if (hl>=25)   str = "Nose picker"; //ranks[2];
    if (hl>=50)   str = "Lawnmower fodder"; //ranks[3];
    if (hl>=100)  str = "Amateur         "; //ranks[4];
    if (hl>=125)  str = "Stick picker"; //ranks[5];
    if (hl>=135)  str = "Grass trampler"; //ranks[6];
    if (hl>=170)  str = "Sticktastic!  "; //ranks[7];
    if (hl>=200)  str = "Mr.Awesome  "; //ranks[8];
    if (hl>=209)  str = "Stick assassin"; //ranks[9];
    if (hl>=211)  str = "Stick pick ninja"; //ranks[10];
    if (hl>=240)  str = "Over the hill   "; //ranks[11];
    if (hl>=280)  str = "No life      "; //ranks[12];
    if (hl>=320)  str = "Srsly no life"; //ranks[13];
    if (hl>=350)  str = "STOP PLAYING NOW"; //ranks[14];
    if (hl>=400)  str = "ARGHH!          "; //ranks[15];
    if (hl>=440)  str = "YOU ARE INSANE"; //ranks[16];
    if (hl>=475)  str = "WHY TORTURING YOURSELF?"; //ranks[17];
    if (hl>=500)  str = "I DARE YOU TO COLLECT 1000"; //ranks[18];
    if (hl>=900)  str = "I'M GOING TO SEGFAULT     "; //ranks[19];
    if (hl>=1000) str = "IMPRESSIVE!          "; //ranks[20];
    if (hl>=1010) str = "CREDITS    "; //ranks[21];
    if (hl>=1020) str = "Original PC version"; //ranks[22];
    if (hl>=1030) str = "Rachel Morris      "; //ranks[23];
    if (hl>=1040) str = "ColecoVision port"; //ranks[24];
    if (hl>=1050) str = "Daniel Bienvenu  "; //ranks[25];
    if (hl>=1075) str = "THANKS FOR PLAYING"; //ranks[26];
    if (hl>=1100) str = "NEXT MESSAGE AT 9001"; //ranks[27];
    if (hl>9000)  str = "IT'S OVER NINE THOUSAND!!!"; //ranks[28];
    
    print_at (1,2,str);
}

void update_score(void)
{
    print_at(14,0,str(player.score));
    print_rank();
}

void show_player(void)
{
    byte i;
    byte x = player.x<<3;
    byte y = player.y<<3;
    byte* spr;
    spr = walkingsprites[(nmi_count&8)>>3]; //spriteAttr0;
    //spr = walkingsprites[player.frame&1];
    
    for (i=0;i<9;i++)
    {
        sprites[i].y = (*spr) + y;
        spr++;
        sprites[i].x = (*spr) + x;
        spr++;
        sprites[i].pattern = (*spr);
        spr++;
        sprites[i].colour = (*spr);
        spr++;
    }
    
    sprites[i].y = 0xd0;

    put_vram(0x1b00,sprites,65);
    
    //put_char(player.x,player.y,48);
}

void erase_player(void)
{
    //erase_stick(player.x,player.y);
}

void update_player(void)
{
    byte x = player.x;
    byte y = player.y;
    byte update = 0;
    if (joypad_1&UP)
    {
        if (y>LIMIT_TOP)
        {
            y--;
            update = 1;
        }
    }
    if (joypad_1&DOWN)
    {
        if (y<LIMIT_BOTTOM)
        {
            y++;
            update = 1;
        }
    }
    if (joypad_1&LEFT)
    {
        if (x>LIMIT_LEFT)
        {
            x--;
            update = 1;
        }
    }
    if (joypad_1&RIGHT)
    {
        if (x<LIMIT_RIGHT)
        {
            x++;
            update = 1;
        }
    }
    
    if (update)
    {
        update = 0;
        erase_player();
        player.y = y;
        player.x = x;
        //player.frame++;
        if (check_stick(x,y))
        {
            erase_stick(x,y);
            update++;
        }
        
        if (check_stick(x,y-1))
        {
            erase_stick(x,y-1);
            update++;
        }
        if (update)
        {
            add_stick(update);
            player.score += update;
            update_score();
            play_sound(14);
        }
        //show_player();
    }
}

void init_screen(void)
{
    byte y;
    byte x;
    byte c;
    
    cls();
    
    for (y=LIMIT_TOP-1;y<=LIMIT_BOTTOM+1;y++)
    {
        c = (y & 1) << 1;
        for (x=0;x<32;x+=2)
        {
            erase_stick(x,y);
        }
    }
    
    add_stick(NBR_STICKS);
    
    update_score();
    
    screen_on();
}

void init(void)
{
    // Reset NMI counter
    nmi_count = 0;
    
    // Player attributes
    player.y = 14;
    player.x = 16;
    player.dir = 0;
    //player.frame = 0;
    player.score = 0; // player's score = zero

    // Music attributes
    music_part = 7;
    music_counter = 159;
    
    // Initialize Display
    init_screen();
}

void main(void)
{
    /* Default Screen Mode 2 */
    /* Sprites already set to 16x16 pixels */
    screen_mode_2_text();
    
    /* Upload BIOS ASCII charset */
    load_ascii();
    fill_vram(0x2000,0xf1,2048);
    
    /* Upload characters pattern and color */
    rle2vram(PATTERNRLE,0x0000);
    duplicate_pattern();
    rle2vram(COLORRLE,0x2000);
    
    /* Upload sprites pattern */
    rle2vram(SPATTERNRLE,0x3800);
    
    init();

    enable_nmi();

infinite_loop:
    goto infinite_loop;
}

void nmi(void)
{
    nmi_count++;
    if (nmi_count&1)
    {
        update_player();
        show_player();
    }
    update_music();
}
